<?php

defined('ABSPATH') || exit;

use \UtillzCore\Inc\Src\Listing\Listing;

global $ulz_item;

?>

<li>
    <a href="<?php if( $ulz_item->type == 'field' ) { echo get_the_permalink( $ulz_item->id ); }else{ echo '#'; } ?>" class="<?php if( $ulz_item->type == 'term' ) { echo 'ulz--selectable'; }else{ echo 'ulz--listing'; } ?> ulz-no-transition"
        <?php if( isset( $ulz_item->taxonomy ) ): ?>data-taxonomy="<?php echo esc_attr( $ulz_item->taxonomy ); ?>"<?php endif; ?>
        data-value="<?php echo esc_attr( $ulz_item->id ); ?>">
        <?php if( $ulz_item->type == 'term' && $ulz_item->icon_set && $ulz_item->icon_icon ): ?>
            <div class="ulz-auto-icon ulz-flex ulz-flex-column ulz-justify-center ulz-text-center">
                <?php echo utillz_core()->icon->get( $ulz_item->icon_icon, $ulz_item->icon_set ); ?>
            </div>
        <?php endif; ?>
        <?php if( $ulz_item->type == 'field' ): ?>
            <?php if( get_post_type( $ulz_item->id ) == 'ulz_collection' ): ?>
                <?php
                    $collection = new \UtillzCore\Inc\Src\Collection\Collection( $ulz_item->id );
                    $gallery = $collection->get_collection_gallery( 1, 'thumbnail' );
                ?>
                <?php if( $gallery ): ?>
                    <?php foreach( $gallery as $collection_image ): ?>
                        <div class="ulz-auto-image">
                            <?php echo '<img src="' . esc_url( $collection_image ) . '" alt="">'; ?>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="ulz-auto-icon ulz-flex ulz-flex-column ulz-justify-center ulz-text-center">
                        <?php echo utillz_core()->icon->get( 'perm_media', 'material-icons' ); ?>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <?php $listing = new Listing( $ulz_item->id ); ?>
                <?php $image = $listing->get_first_from_gallery('thumbnail'); ?>
                <?php if( $image ): ?>
                    <div class="ulz-auto-image">
                        <?php echo '<img src="' . esc_url( $image ) . '" alt="">'; ?>
                    </div>
                <?php else: ?>
                    <div class="ulz-auto-icon ulz-flex ulz-flex-column ulz-justify-center ulz-text-center">
                        <?php echo utillz_core()->icon->get( 'image', 'material-icons' ); ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>
        <div class="ulz-auto-content ulz-ellipsis">
            <span class="ulz--name"><?php echo $ulz_item->name; ?></span>
            <?php if( get_post_type( $ulz_item->id ) == 'ulz_collection' ): ?>
                <span class="ulz--path"><?php esc_html_e('Collection', 'utillz'); ?></span>
            <?php elseif( $ulz_item->type == 'term' ): ?>
                <span class="ulz--path"><?php echo esc_attr( $ulz_item->taxonomy_name ); ?></span>
            <?php endif; ?>
        </div>
        <?php if( $ulz_item->type == 'field' ): ?>
            <div class="ulz-auto-target">
                <i class="material-icons">launch</i>
            </div>
        <?php endif; ?>
    </a>
</li>
